<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:ns1="http://www.mf.gov.pl/SENT/2017/12/08/SENT_181.xsd"
				xmlns:tp="http://www.mf.gov.pl/SENT/2017/12/08/STypes.xsd">
	<xsl:template match="ns1:SENT_181">
		<!-- TODO: Auto-generated template -->
		<html>
			<head>
        <style>
          * {
          -webkit-print-color-adjust: exact !important;
          color-adjust: exact !important;
          }

          @media print {
          body {-webkit-print-color-adjust: exact;}
          }

          body {
          font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
          margin: 0 auto;
          padding: 0 auto;
          }

          .sent-xslt {
          border-collapse: initial;
          }

          .sent-xslt h1 {
          padding: 6px 4px 4px 10px;
          color:#000000;
          margin-top: 0;
          background-color:#c5c2c2;
          font-weight: normal;
          font-size: 12px;
          margin-bottom: 0;
          border-bottom: 1px solid #c8c9ca;
          }

          .sent-xslt .s1 {
          max-width: 1220px;
          border: 1px solid #c8c9ca;
          }

          .sent-xslt .t1 {
          position: relative;
          display: table;
          width: 100%;
          }

          .sent-xslt .t2 {
          padding: 15px 5px 3px 5px;
          border: 1px solid;
          margin: 0 10px 20px 10px;
          }

          .sent-xslt .t3 {
          padding: 15px 5px 3px 5px;
          border: 1px solid red;
          margin: 0 10px 20px 10px;
          }

          .sent-xslt .grupName {
          font-size: 12px;
          margin: 0 !important;
          font-weight: bold;
          display:block;
          color: #000000;
          background-color:#dbddde;
          padding:5px 5px 5px 10px;
          border-top: 1px solid #dbddde;
          }

          .sent-xslt .grupNameRed {
          font-size: 14px;
          margin: -15px -5px 0 -5px;
          font-weight: bold;
          display:block;
          color: #000000;
          background-color:red;
          padding:5px 5px 5px 10px;
          border: 1px solid red;
          }

          .sent-xslt .element-1 {
          font-size: 12px;
          font-weight: normal;
          }

          .sent-xslt .element-2 {
          font-size: 14px;
          font-weight: normal;
          color: #008540;
          }

          .sent-xslt .green {
          background-color: #DAFFCC;
          height: 35px;
          padding-top: 4px;
          }

          .sent-xslt .green-key {
          background-color: #DAFFCC;
          padding: 7px 0px !important;
          }

          .sent-xslt .element-3 {
          font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
          font-size: 12px;
          font-weight: normal;
          border-spacing: 10 10;
          white-space: pre-wrap; /* Since CSS 2.1 */
          white-space: -moz-pre-wrap; /* Mozilla, since 1999 */
          white-space: -pre-wrap; /* Opera 4-6 */
          white-space: -o-pre-wrap; /* Opera 7 */
          word-wrap: break-word; /* Internet Explorer 5.5+ */
          word-break: normal;
          }
          
          .sent-xslt .grupInfo p {
          margin: 1px 0 1px 10px;
          font-weight: bold;
          font-size: 12px;
          }

          .sent-xslt .grupInfo {
          border-top: 1px solid #dbddde;
          }

          .sent-xslt .grupInfoSent {
          min-height: 40px;
          }

          .sent-xslt .grupInfoSent p {
          margin: -2px 0 1px 10px;
          font-size: 16px;
          font-weight: bold;
          }

          .sent-xslt .oilstatus {
          margin: 0 5px 0 -5px;
          margin: 2px 0 1px 10px;
          font-size: 14px;
          padding-bottom: 12px;
          color: red;
          }

          .sent-xslt .info {
          width: 100%;
          float: left;
          display: table-cell;
          padding: 4px 0px;
          }

          .sent-xslt .info1 {
          width: 50%;
          float: left;
          display: table-cell;
          padding: 4px 0px;
          }

          .sent-xslt .info3 {
          width: 33%;
          float: left;
          display: table-cell;
          }

          .sent-xslt .lang ul {
          margin: 0 auto;
          padding: 0;
          }

          .sent-xslt .lang ul li {
          display: inline;
          margin-left: 10px;
          }

          .sent-xslt .table {
          display: table;
          width: 99%;
          margin: 4px 0 15px 7px;
          border-spacing: 0 0;
          border-top: 1px solid #999999;
          border-left: 1px solid #999999;
          }

          .sent-xslt .table-header {
          font-size: 10px;
          font-weight: bold;
          padding: 5px;
          background-color: #ececec;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }

          .sent-xslt .table-element {
          font-size: 12px;
          font-weight: normal;
          padding: 2px 5px;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }

          .sent-xslt .table-element2 {
          font-size: 12px;
          font-weight: normal;
          padding: 0;
          }

          .sent-xslt .table-element3 {
          font-size: 12px;
          font-weight: bold;
          border: 1px #999999;
          border-top-style: solid;
          margin: 0;
          }

          .sent-xslt .table-element p {
          margin-left: 0;
          }

          .sent-xslt .table-element2 p {
          margin-left: 0;
          }

          .sent-xslt .table-element3 p {
          margin-left: 0;
          padding: 0px 5px;
          }

        </style>
			</head>
      <body>
          <div class="sent-xslt">
            <section class="sent-xslt s1">
              <h1>SENT181 - POTWIERDZENIE REJESTRACJI UMOWY</h1>
              <div class="sent-xslt t1">
                <div class="sent-xslt grupInfoSent">
                  <div class="sent-xslt info1">
                    <p>
                      <span class="sent-xslt element-1 sent">NUMER UMOWY: </span>
                      <br/>
                      <xsl:value-of select="ns1:AgreementNumber"/>
                    </p>
                  </div>
                </div>
              </div>
              <div class="sent-xslt t1">
                <p class="sent-xslt grupName">DANE INFORMACYJNE O ZGŁOSZENIU</p>
                <div class="sent-xslt grupInfo">
                  <div class="sent-xslt info1">
                    <xsl:variable name="creDate" select="substring-before(ns1:RegisteredAgreementInfo/tp:CreationDate, 'T')"/>
                    <xsl:variable name="creTime" select="substring(ns1:RegisteredAgreementInfo/tp:CreationDate, 12,8)"/>
                    <p>
                      <span class="sent-xslt element-1">Data utworzenia: </span>
                      <xsl:value-of select="$creDate"/>&#160;<xsl:value-of select="$creTime"/>
                    </p>
                    <p>
                      <span class="sent-xslt element-1">Użytkownik rejestrujący: </span>
                      <xsl:value-of select="ns1:RegisteredAgreementInfo/tp:Creator"/>
                    </p>
                    <xsl:variable name="modDate" select="substring-before(ns1:RegisteredAgreementInfo/tp:ModificationDate, 'T')"/>
                    <xsl:variable name="modTime" select="substring(ns1:RegisteredAgreementInfo/tp:ModificationDate, 12,8)"/>
                    <p>
                      <span class="sent-xslt element-1">Data modyfikacji: </span>
                      <xsl:value-of select="$modDate"/>&#160;<xsl:value-of select="$modTime"/>
                    </p>
                    <p>
                      <span class="sent-xslt element-1">Użytkownik modyfikujący: </span>
                      <xsl:value-of select="ns1:RegisteredAgreementInfo/tp:Modifier"/>
                    </p>
                  </div>
                  <div class="sent-xslt info1">
                    <xsl:if test="ns1:RegisteredAgreementInfo/tp:SourceDocumentId !=''">
                      <p>
                        <span class="sent-xslt element-1">Numer własny: </span>
                        <xsl:value-of select="ns1:RegisteredAgreementInfo/tp:SourceDocumentId"/>
                      </p>
                    </xsl:if>
                    <p>
                      <span class="sent-xslt element-1">Suma kontrolna: </span>
                      <xsl:value-of select="ns1:RegisteredAgreementInfo/tp:ChecksumOfSourceDocument"/>
                    </p>
                    <p>
                      <span class="sent-xslt element-1">Status: </span>
                      <xsl:choose>
                        <xsl:when test="ns1:RegisteredAgreementInfo/tp:RegistrationStatus = '0'">
                          <span>zarejestrowana</span>
                        </xsl:when>
                        <xsl:when test="ns1:RegisteredAgreementInfo/tp:RegistrationStatus = '2'">
                          <span>aktywna</span>
                        </xsl:when>
                        <xsl:when test="ns1:RegisteredAgreementInfo/tp:RegistrationStatus = '3'">
                          <span>zakończona</span>
                        </xsl:when>
                        <xsl:when test="ns1:RegisteredAgreementInfo/tp:RegistrationStatus = '4'">
                          <span>anulowana</span>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="ns1:RegisteredAgreementInfo/tp:RegistrationStatus"/>
                        </xsl:otherwise>
                      </xsl:choose>
                    </p>
                  </div>
                </div>
              </div>
              <div class="sent-xslt t1">
                <p class="sent-xslt grupName">DANE IDENTYFIKACYJNE PODMIOTU SPRZEDAJĄCEGO</p>
                <div class="sent-xslt grupInfo">
                  <div class="sent-xslt info1">
                    <xsl:if test="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderInfo/tp:IdSisc !=''">
                      <p>
                        <span class="sent-xslt element-1">Identyfikator idSISC: </span>
                        <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderInfo/tp:IdSisc"/>
                      </p>
                    </xsl:if>
                    <p>
                      <span class="sent-xslt element-1">Nazwa pełna: </span>
                      <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderInfo/tp:TraderOrPersonName"/>
                    </p>
                    <p>
                      <span class="sent-xslt element-1">Typ identyfikatora: </span>
                      <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderInfo/tp:TraderIdentityType"/>
                    </p>
                    <p>
                      <span class="sent-xslt element-1">Numer identyfikatora: </span>
                      <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderInfo/tp:TraderIdentityNumber"/>
                    </p>
                  </div>
                  <div class="sent-xslt info1">
                    <p>
                      <span class="sent-xslt element-2">Adres siedziby</span>
                    </p>
                    <xsl:variable name="ulica">
                      <xsl:choose>
                        <xsl:when test="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:FlatNumber != ''">
                          <p>
                            <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:Street"/>
                            <xsl:text>&#160;</xsl:text> <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:HouseNumber"/>&#160;/&#160;<xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:FlatNumber"/>
                          </p>
                        </xsl:when>
                        <xsl:otherwise>
                          <p>
                            <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:Street"/>
                            <xsl:text>&#160;</xsl:text>
                            <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:HouseNumber"/>
                          </p>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:variable>
                    <p>
                      <xsl:value-of select="$ulica"/>
                    </p>
                    <p>
                      <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:PostalCode"/>
                      <xsl:text>&#160;</xsl:text>
                      <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:City"/>
                      <xsl:if test="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:City != ''">,</xsl:if>
                      <xsl:text>&#160;</xsl:text>
                      <xsl:value-of select="ns1:RegisteredInformationAboutSender/tp:RegisteredAgreementTraderAddress/tp:Country"/>
                    </p>
                  </div>
                </div>
              </div>
              <div class="sent-xslt t1">
                <p class="sent-xslt grupName">DANE IDENTYFIKACYJNE PODMIOTU ODBIERAJĄCEGO</p>
                <div class="sent-xslt grupInfo">
                  <div class="sent-xslt info1">
                    <xsl:if test="ns1:RegisteredInformationAboutRecipient/tp:RegisteredAgreementTraderInfo/tp:IdSisc !=''">
                      <p>
                        <span class="sent-xslt element-1">Identyfikator idSISC: </span>
                        <xsl:value-of select="ns1:RegisteredInformationAboutRecipient/tp:RegisteredAgreementTraderInfo/tp:IdSisc"/>
                      </p>
                    </xsl:if>
                    <p>
                      <span class="sent-xslt element-1">Nazwa pełna: </span>
                      <xsl:value-of select="ns1:RegisteredInformationAboutRecipient/tp:RegisteredAgreementTraderInfo/tp:TraderOrPersonName"/>
                    </p>
                    <p>
                      <span class="sent-xslt element-1">Typ identyfikatora: </span>
                      <xsl:value-of select="ns1:RegisteredInformationAboutRecipient/tp:RegisteredAgreementTraderInfo/tp:TraderIdentityType"/>
                    </p>
                    <p>
                      <span class="sent-xslt element-1">Numer identyfikatora: </span>
                      <xsl:value-of select="ns1:RegisteredInformationAboutRecipient/tp:RegisteredAgreementTraderInfo/tp:TraderIdentityNumber"/>
                    </p>
                  </div>
                  <div class="sent-xslt info1">
                    <p>
                      <span class="sent-xslt element-2">Adres siedziby</span>
                    </p>
                    <xsl:variable name="ulica">
                      <xsl:choose>
                        <xsl:when test="ns1:RegisteredInformationAboutRecipient/tp:RegisteredAgreementTraderAddress/tp:FlatNumber != ''">
                          <p>
                            <xsl:value-of select="ns1:RegisteredInformationAboutRecipient/tp:RegisteredAgreementTraderAddress/tp:Street"/>
                            <xsl:text>&#160;</xsl:text> <xsl:value-of select="ns1:RegisteredInformationAboutRecipient/tp:RegisteredAgreementTraderAddress/tp:HouseNumber"/>&#160;/&#160;<xsl:value-of select="ns1:RegisteredInformationAboutRecipient/tp:RegisteredAgreementTraderAddress/tp:FlatNumber"/>
                          </p>
                        </xsl:when>
                        <xsl:otherwise>
                          <p>
                            <xsl:value-of select="ns1:RegisteredInformationAboutRecipient/tp:RegisteredAgreementTraderAddress/tp:Street"/>
                            <xsl:text>&#160;</xsl:text>
                            <xsl:value-of select="ns1:RegisteredInformationAboutRecipient/tp:RegisteredAgreementTraderAddress/tp:HouseNumber"/>
                          </p>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:variable>
                    <p>
                      <xsl:value-of select="$ulica"/>
                    </p>
                    <p>
                      <xsl:value-of select="ns1:RegisteredInformationAboutRecipient/tp:RegisteredAgreementTraderAddress/tp:PostalCode"/>
                      <xsl:text>&#160;</xsl:text>
                      <xsl:value-of select="ns1:RegisteredInformationAboutRecipient/tp:RegisteredAgreementTraderAddress/tp:City"/>
                      <xsl:if test="ns1:RegisteredInformationAboutRecipient/tp:RegisteredAgreementTraderAddress/tp:City != ''">,</xsl:if>
                      <xsl:text>&#160;</xsl:text>
                      <xsl:value-of select="ns1:RegisteredInformationAboutRecipient/tp:RegisteredAgreementTraderAddress/tp:Country"/>
                    </p>
                  </div>
                </div>
              </div>
              <div class="sent-xslt t1">
                <p class="sent-xslt grupName">DANE DOTYCZĄCE UMOWY</p>
                <div class="sent-xslt t1">
                  <div class="sent-xslt grupInfo">
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-1">obowiązuje od: </span>
                        <xsl:choose>
                          <xsl:when test="string-length(ns1:InformationAboutAgreement/tp:DateAgreementFrom) > 10">
                            <xsl:value-of select="substring-before(ns1:InformationAboutAgreement/tp:DateAgreementFrom, '+')"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="ns1:InformationAboutAgreement/tp:DateAgreementFrom"/>
                          </xsl:otherwise>
                        </xsl:choose>
                        <span class="sent-xslt element-1"> do: </span>
                        <xsl:choose>
                          <xsl:when test="string-length(ns1:InformationAboutAgreement/tp:DateAgreementTo) > 10">
                            <xsl:value-of select="substring-before(ns1:InformationAboutAgreement/tp:DateAgreementTo, '+')"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="ns1:InformationAboutAgreement/tp:DateAgreementTo"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </p>
                    </div>
                    <div class="sent-xslt info1">
                      <p>
                        <xsl:choose>
                          <xsl:when test="ns1:InformationAboutAgreement/tp:UnitOfMeasure ='kg'"><span class="sent-xslt element-1">Ilość oleju opałowego ciężkiego: </span></xsl:when>
                          <xsl:when test="ns1:InformationAboutAgreement/tp:UnitOfMeasure ='l'"><span class="sent-xslt element-1">Ilość oleju opałowego lekkiego: </span></xsl:when>
                          <xsl:otherwise><span class="sent-xslt element-1">Ilość oleju opałowego: </span> </xsl:otherwise>
                        </xsl:choose>
                        <xsl:value-of select="ns1:InformationAboutAgreement/tp:AgreementAmountOfGoods"/>&#160;<xsl:value-of select="ns1:InformationAboutAgreement/tp:UnitOfMeasure"/>
                      </p>
                    </div>
                  </div>
                </div>
              </div>
              <xsl:if test="ns1:Comments != ''">
                <div class="sent-xslt t1">
                  <p class="sent-xslt grupName">UWAGI</p>
                  <div class="sent-xslt t1">
                    <div class="sent-xslt grupInfo">
                      <div class="sent-xslt info1">
                        <xsl:if test="ns1:Comments != ''">
                          <p>
                            <xsl:value-of select="ns1:Comments"/>
                          </p>
                        </xsl:if>
                      </div>
                    </div>
                  </div>
                </div>
              </xsl:if>
            </section>
          </div>
      </body>
    </html>
	</xsl:template>
</xsl:stylesheet>
